package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.EstudioDocOS3;
import com.ejie.ab04b.model.TareaOS3;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0444s00DaoImpl generated by UDA, 14-Feb-2017 10:29:39.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class EstudioDocOS3DaoImpl implements EstudioDocOS3Dao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_044 IDTAREA044, t1.RESULTADO_044 RESULTADO044, t1.NOTAS_044 NOTAS044 FROM AB0444S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<EstudioDocOS3> rwMap = new RowMapper<EstudioDocOS3>() {
		public EstudioDocOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EstudioDocOS3(new TareaOS3(
					resultSet.getLong("IDTAREA044")),
					resultSet.getString("RESULTADO044"),
					resultSet.getString("NOTAS044"));
		}
	};

	private RowMapper<EstudioDocOS3> rwMapPK = new RowMapper<EstudioDocOS3>() {
		public EstudioDocOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EstudioDocOS3(new TareaOS3(
					resultSet.getLong("IDTAREA044")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0444s00 table.
	 * 
	 * ab0444s00 Ab0444s00 Ab0444s00
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @return the estudio doc OS 3
	 */
	public EstudioDocOS3 add(EstudioDocOS3 ab0444s00) {
		String query = "INSERT INTO AB0444S00 (ID_TAREA_044, RESULTADO_044) VALUES (?,?)";
		this.jdbcTemplate.update(query,
				ab0444s00.getTareaOS3().getIdTarea096(),
				ab0444s00.getResultado044());
		return ab0444s00;
	}

	/**
	 * Updates a single row in the Ab0444s00 table.
	 * 
	 * ab0444s00 Ab0444s00 Ab0444s00
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @return the estudio doc OS 3
	 */
	public EstudioDocOS3 update(EstudioDocOS3 ab0444s00) {
		String query = "UPDATE AB0444S00 SET RESULTADO_044=?, NOTAS_044=? WHERE ID_TAREA_044=?";
		this.jdbcTemplate.update(query, ab0444s00.getResultado044(), ab0444s00
				.getNotas044(), ab0444s00.getTareaOS3().getIdTarea096());
		return ab0444s00;
	}

	/**
	 * Finds a single row in the Ab0444s00 table.
	 * 
	 * ab0444s00 Ab0444s00 Ab0444s00
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @return the estudio doc OS 3
	 */
	@Transactional(readOnly = true)
	public EstudioDocOS3 find(EstudioDocOS3 ab0444s00) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS3DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_044 = ? ");

		List<EstudioDocOS3> ab0444s00List = this.jdbcTemplate.query(query
				.toString(), this.rwMap, ab0444s00.getTareaOS3()
				.getIdTarea096());
		return (EstudioDocOS3) DataAccessUtils.uniqueResult(ab0444s00List);
	}

	/**
	 * Removes a single row in the Ab0444s00 table.
	 * 
	 * ab0444s00 Ab0444s00
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 */
	public void remove(EstudioDocOS3 ab0444s00) {
		String query = "DELETE FROM AB0444S00 WHERE ID_TAREA_044=?";
		this.jdbcTemplate
				.update(query, ab0444s00.getTareaOS3().getIdTarea096());
	}

	/**
	 * Finds a list of rows in the Ab0444s00 table.
	 * 
	 * ab0444s00 Ab0444s00 jqGridRequestDto JQGridRequestDto List<Ab0444s00>
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EstudioDocOS3> findAll(EstudioDocOS3 ab0444s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS3DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0444s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EstudioDocOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0444s00 table using like.
	 * 
	 * ab0444s00 Ab0444s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0444s00>
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EstudioDocOS3> findAllLike(EstudioDocOS3 ab0444s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS3DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0444s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EstudioDocOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0444s00 table.
	 * 
	 * ab0444s00 Ab0444s00 Long
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EstudioDocOS3 ab0444s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0444S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0444s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0444s00 table using like.
	 * 
	 * ab0444s00 Ab0444s00 startsWith Boolean Long
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(EstudioDocOS3 ab0444s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0444S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0444s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0444s00 selected for rup_table.
	 * 
	 * ab0444s00 Ab0444s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Ab0444s00>>
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EstudioDocOS3>> reorderSelection(
			EstudioDocOS3 ab0444s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS3DaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0444s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, EstudioDocOS3.class, filterParamList,
				"ID_ESTUDIO_APERTURA_044");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EstudioDocOS3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab0444s00 searchParams Ab0444s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0444s00>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EstudioDocOS3>> search(EstudioDocOS3 filterParams,
			EstudioDocOS3 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstudioDocOS3DaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, EstudioDocOS3.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"ID_ESTUDIO_APERTURA_044");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EstudioDocOS3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0444s00 entity.
	 * 
	 * ab0444s00 Ab0444s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EstudioDocOS3 ab0444s00) {

		StringBuilder where = new StringBuilder(
				EstudioDocOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0444s00 != null && ab0444s00.getTareaOS3() != null
				&& ab0444s00.getTareaOS3().getIdTarea096() != null) {
			where.append(" AND t1.ID_TAREA_044 = ?");
			params.add(ab0444s00.getTareaOS3().getIdTarea096());
		}
		if (ab0444s00 != null && ab0444s00.getResultado044() != null) {
			where.append(" AND t1.RESULTADO_044 = ?");
			params.add(ab0444s00.getResultado044());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0444s00 entity.
	 * 
	 * ab0444s00 Ab0444s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0444s00
	 *            the ab 0444 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(EstudioDocOS3 ab0444s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EstudioDocOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0444s00 != null && ab0444s00.getTareaOS3() != null
				&& ab0444s00.getTareaOS3().getIdTarea096() != null) {
			where.append(" AND t1.ID_TAREA_044 = ?");
			params.add(ab0444s00.getTareaOS3().getIdTarea096());
		}
		if (ab0444s00 != null && ab0444s00.getResultado044() != null) {
			where.append(" AND UPPER(t1.RESULTADO_044) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0444s00.getResultado044().toUpperCase() + "%");
			} else {
				params.add("%" + ab0444s00.getResultado044().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RESULTADO_044 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
